/*
 * Decompiled with CFR 0.152.
 */
package com.sun.xml.internal.ws.message;

import com.sun.istack.internal.NotNull;
import com.sun.xml.internal.bind.api.Bridge;
import com.sun.xml.internal.ws.api.SOAPVersion;
import com.sun.xml.internal.ws.api.message.Header;
import com.sun.xml.internal.ws.api.message.Message;
import com.sun.xml.internal.ws.api.message.MessageHeaders;
import com.sun.xml.internal.ws.api.message.MessageWritable;
import com.sun.xml.internal.ws.api.message.Packet;
import com.sun.xml.internal.ws.api.message.saaj.SAAJFactory;
import com.sun.xml.internal.ws.encoding.TagInfoset;
import com.sun.xml.internal.ws.message.AttachmentUnmarshallerImpl;
import com.sun.xml.internal.ws.message.XMLReaderImpl;
import com.sun.xml.internal.ws.message.saaj.SAAJMessage;
import com.sun.xml.internal.ws.spi.db.XMLBridge;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import javax.xml.bind.JAXBException;
import javax.xml.bind.Unmarshaller;
import javax.xml.bind.attachment.AttachmentUnmarshaller;
import javax.xml.soap.SOAPException;
import javax.xml.soap.SOAPMessage;
import javax.xml.stream.XMLStreamException;
import javax.xml.stream.XMLStreamWriter;
import javax.xml.transform.Source;
import javax.xml.transform.sax.SAXSource;
import org.xml.sax.ContentHandler;
import org.xml.sax.ErrorHandler;
import org.xml.sax.SAXException;
import org.xml.sax.helpers.AttributesImpl;
import org.xml.sax.helpers.LocatorImpl;

public abstract class AbstractMessageImpl
extends Message {
    protected final SOAPVersion soapVersion;
    @NotNull
    protected TagInfoset envelopeTag;
    @NotNull
    protected TagInfoset headerTag;
    @NotNull
    protected TagInfoset bodyTag;
    protected static final AttributesImpl EMPTY_ATTS;
    protected static final LocatorImpl NULL_LOCATOR;
    protected static final List<TagInfoset> DEFAULT_TAGS;

    static void create(SOAPVersion sOAPVersion, List list) {
        int n = sOAPVersion.ordinal() * 3;
        list.add(n, new TagInfoset(sOAPVersion.nsUri, "Envelope", "S", EMPTY_ATTS, "S", sOAPVersion.nsUri));
        list.add(n + 1, new TagInfoset(sOAPVersion.nsUri, "Header", "S", EMPTY_ATTS, new String[0]));
        list.add(n + 2, new TagInfoset(sOAPVersion.nsUri, "Body", "S", EMPTY_ATTS, new String[0]));
    }

    protected AbstractMessageImpl(SOAPVersion sOAPVersion) {
        this.soapVersion = sOAPVersion;
    }

    @Override
    public SOAPVersion getSOAPVersion() {
        return this.soapVersion;
    }

    protected AbstractMessageImpl(AbstractMessageImpl abstractMessageImpl) {
        this.soapVersion = abstractMessageImpl.soapVersion;
    }

    @Override
    public Source readEnvelopeAsSource() {
        return new SAXSource(new XMLReaderImpl(this), XMLReaderImpl.THE_SOURCE);
    }

    @Override
    public <T> T readPayloadAsJAXB(Unmarshaller unmarshaller) throws JAXBException {
        if (this.hasAttachments()) {
            unmarshaller.setAttachmentUnmarshaller(new AttachmentUnmarshallerImpl(this.getAttachments()));
        }
        try {
            Object object = unmarshaller.unmarshal(this.readPayloadAsSource());
            return (T)object;
        }
        finally {
            unmarshaller.setAttachmentUnmarshaller(null);
        }
    }

    @Override
    public <T> T readPayloadAsJAXB(Bridge<T> bridge) throws JAXBException {
        return bridge.unmarshal(this.readPayloadAsSource(), (AttachmentUnmarshaller)(this.hasAttachments() ? new AttachmentUnmarshallerImpl(this.getAttachments()) : null));
    }

    @Override
    public <T> T readPayloadAsJAXB(XMLBridge<T> xMLBridge) throws JAXBException {
        return xMLBridge.unmarshal(this.readPayloadAsSource(), (AttachmentUnmarshaller)(this.hasAttachments() ? new AttachmentUnmarshallerImpl(this.getAttachments()) : null));
    }

    @Override
    public void writeTo(XMLStreamWriter xMLStreamWriter) throws XMLStreamException {
        String string = this.soapVersion.nsUri;
        xMLStreamWriter.writeStartDocument();
        xMLStreamWriter.writeStartElement("S", "Envelope", string);
        xMLStreamWriter.writeNamespace("S", string);
        if (this.hasHeaders()) {
            xMLStreamWriter.writeStartElement("S", "Header", string);
            MessageHeaders messageHeaders = this.getHeaders();
            for (Header header : messageHeaders.asList()) {
                header.writeTo(xMLStreamWriter);
            }
            xMLStreamWriter.writeEndElement();
        }
        xMLStreamWriter.writeStartElement("S", "Body", string);
        this.writePayloadTo(xMLStreamWriter);
        xMLStreamWriter.writeEndElement();
        xMLStreamWriter.writeEndElement();
        xMLStreamWriter.writeEndDocument();
    }

    @Override
    public void writeTo(ContentHandler contentHandler, ErrorHandler errorHandler) throws SAXException {
        String string = this.soapVersion.nsUri;
        contentHandler.setDocumentLocator(NULL_LOCATOR);
        contentHandler.startDocument();
        contentHandler.startPrefixMapping("S", string);
        contentHandler.startElement(string, "Envelope", "S:Envelope", EMPTY_ATTS);
        if (this.hasHeaders()) {
            contentHandler.startElement(string, "Header", "S:Header", EMPTY_ATTS);
            MessageHeaders messageHeaders = this.getHeaders();
            for (Header header : messageHeaders.asList()) {
                header.writeTo(contentHandler, errorHandler);
            }
            contentHandler.endElement(string, "Header", "S:Header");
        }
        contentHandler.startElement(string, "Body", "S:Body", EMPTY_ATTS);
        this.writePayloadTo(contentHandler, errorHandler, true);
        contentHandler.endElement(string, "Body", "S:Body");
        contentHandler.endElement(string, "Envelope", "S:Envelope");
    }

    protected abstract void writePayloadTo(ContentHandler var1, ErrorHandler var2, boolean var3) throws SAXException;

    public Message toSAAJ(Packet packet, Boolean bl) throws SOAPException {
        SAAJMessage sAAJMessage = SAAJFactory.read(packet);
        if (sAAJMessage instanceof MessageWritable) {
            ((MessageWritable)((Object)sAAJMessage)).setMTOMConfiguration(packet.getMtomFeature());
        }
        if (bl != null) {
            this.transportHeaders(packet, bl, sAAJMessage.readAsSOAPMessage());
        }
        return sAAJMessage;
    }

    @Override
    public SOAPMessage readAsSOAPMessage() throws SOAPException {
        return SAAJFactory.read(this.soapVersion, this);
    }

    @Override
    public SOAPMessage readAsSOAPMessage(Packet packet, boolean bl) throws SOAPException {
        SOAPMessage sOAPMessage = SAAJFactory.read(this.soapVersion, this, packet);
        this.transportHeaders(packet, bl, sOAPMessage);
        return sOAPMessage;
    }

    private void transportHeaders(Packet packet, boolean bl, SOAPMessage sOAPMessage) throws SOAPException {
        Map<String, List<String>> map = AbstractMessageImpl.getTransportHeaders(packet, bl);
        if (map != null) {
            AbstractMessageImpl.addSOAPMimeHeaders(sOAPMessage.getMimeHeaders(), map);
        }
        if (sOAPMessage.saveRequired()) {
            sOAPMessage.saveChanges();
        }
    }

    static {
        NULL_LOCATOR = new LocatorImpl();
        EMPTY_ATTS = new AttributesImpl();
        ArrayList arrayList = new ArrayList();
        AbstractMessageImpl.create(SOAPVersion.SOAP_11, arrayList);
        AbstractMessageImpl.create(SOAPVersion.SOAP_12, arrayList);
        DEFAULT_TAGS = Collections.unmodifiableList(arrayList);
    }
}

